/*
 Important:
 This is sample code demonstrating API, technology or techniques in development.
 Although this sample code has been reviewed for technical accuracy, it is not 
 final. Apple is supplying this information to help you plan for the adoption of 
 the technologies and programming interfaces described herein. This information 
 is subject to change, and software implemented based on this sample code should 
 be tested with final operating system software and final documentation. Newer 
 versions of this sample code may be provided with future seeds of the API or 
 technology. For information about updates to this and other developer 
 documentation, view the New & Updated sidebars in subsequent documentation seeds.
 */
/*
 File: Leaves.js
 Abstract: Defines JavaScript functionality for the leaves sample.
 Creates all the leaves but do not animate them. Determines which
 spin animation should be applied to each leaf.
 Version: 1.0
 Disclaimer: IMPORTANT:  This Apple software is supplied to you by
 Apple Inc. ("Apple") in consideration of your agreement to the
 following terms, and your use, installation, modification or
 redistribution of this Apple software constitutes acceptance of these
 terms.  If you do not agree with these terms, please do not use,
 install, modify or redistribute this Apple software.
 In consideration of your agreement to abide by the following terms, and
 subject to these terms, Apple grants you a personal, non-exclusive
 license, under Apple's copyrights in this original Apple software (the
 "Apple Software"), to use, reproduce, modify and redistribute the Apple
 Software, with or without modifications, in source and/or binary forms;
 provided that if you redistribute the Apple Software in its entirety and
 without modifications, you must retain this notice and the following
 text and disclaimers in all such redistributions of the Apple Software.
 Neither the name, trademarks, service marks or logos of Apple Inc.
 may be used to endorse or promote products derived from the Apple
 Software without specific prior written permission from Apple.  Except
 as expressly stated in this notice, no other rights or licenses, express
 or implied, are granted by Apple herein, including but not limited to
 any patent rights that may be infringed by your derivative works or by
 other works in which the Apple Software may be incorporated.
 The Apple Software is provided by Apple on an "AS IS" basis.  APPLE
 MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION
 THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS
 FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND
 OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.
 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION,
 MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED
 AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE),
 STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.
 Copyright (C) 2008 Apple Inc. All Rights Reserved.
 */
/* Define the number of leaves to be used in the animation */
const NUMBER_OF_LEAVES = 80;
/* 
 Called when the "Falling Leaves" page is completely loaded.
 */
function initLeaves(elementId)
{
    /* Get a reference to the element that will contain the leaves */
    var container = document.getElementById(elementId);
    /* Fill the empty container with new leaves */
    for (var i = 0; i < NUMBER_OF_LEAVES; i++)
    {
        container.appendChild(createALeaf());
    }
}
/*
 Receives the lowest and highest values of a range and
 returns a random integer that falls within that range.
 */
function randomInteger(low, high)
{
    return low + Math.floor(Math.random() * (high - low));
}
/*
 Receives the lowest and highest values of a range and
 returns a random float that falls within that range.
 */
function randomFloat(low, high)
{
    return low + Math.random() * (high - low);
}
/*
 Receives a number and returns its CSS pixel value.
 */
function pixelValue(value)
{
    return value + 'px';
}

function remValue(value)
{
    return value / 20 + 'rem';
}
/*
 Returns a duration value for the falling animation.
 */
function durationValue(value)
{
    return value + 's';
}
/*
 Uses an img element to create each leaf. "Leaves.css" implements two spin 
 animations for the leaves: clockwiseSpin and counterclockwiseSpinAndFlip. This
 function determines which of these spin animations should be applied to each leaf.
 */
function createALeaf()
{
    /* Start by creating a wrapper div, and an empty img element */
    var leafDiv = document.createElement('div');
    var image = document.createElement('img');
    /* Randomly choose a leaf image and assign it to the newly created element */
    image.src = window.base_resource_url + '/image2/snow-' + randomInteger(1, 4) + '.png';
    console.log(randomInteger(1, 3));
    leafDiv.style.top = "-100px";
    /* Position the leaf at a random location along the screen */
    leafDiv.style.left = pixelValue(randomInteger(0, 500));
    /* Randomly choose a spin animation */
    var spinAnimationName = (Math.random() < 0.5) ? 'clockwiseSpin' : 'counterclockwiseSpinAndFlip';
    /* Set the -webkit-animation-name property with these values */
    leafDiv.style.webkitAnimationName = 'fade, drop';
    image.style.webkitAnimationName = spinAnimationName;
    /* Figure out a random duration for the fade and drop animations */
    var fadeAndDropDuration = durationValue(randomFloat(5, 11));
    /* Figure out another random duration for the spin animation */
    var spinDuration = durationValue(randomFloat(4, 8));
    /* Set the -webkit-animation-duration property with these values */
    leafDiv.style.webkitAnimationDuration = fadeAndDropDuration + ', ' + fadeAndDropDuration;
    var leafDelay = durationValue(randomFloat(0, 6));
    // leafDiv.style.webkitAnimationDelay = leafDelay + ', ' + leafDelay;
    leafDiv.style.webkitAnimationDelay = leafDelay + ', ' + leafDelay;
    image.style.webkitAnimationDuration = spinDuration;
    // add the <img> to the <div>
    leafDiv.appendChild(image);
    /* Return this img element so it can be added to the document */
    return leafDiv;
}
/* Calls the init function when the "Falling Leaves" page is full loaded */
// window.addEventListener('load', init, false);