<?php
namespace Home\Controller;
vendor('tencentsdk.TCloudAutoLoader');

use Think\Controller;
use SignedCookie;
// use Zhida\OAuthHelperV3;
use Common\Common\OAuthHelperV3;
use Think\Upload\Driver\Qiniu\QiniuStorage;

use Think\Log;

class IndexController extends Controller
{
    private $auth_type = OAuthHelperV3::SCOPE_USERINFO;
    private $cookie_uid_key = 'skp-rotor-v1';
    private $debug = 1;
    private $today;
    use ControllerTrait;
    
    public function index()
    {
      $user = $this->get_user_info_from_cookie();
      // 如果没有获取到用户信息，引导用户授权
      if (!$user) {
          $this->request_auth($this->get_url());
          return;
      }

      session_start();
      $_SESSION['joinTime'] = time();

      $this->assign('headimgurl');
      $this->assign('user_header_url',$user['headimgurl']);
      $this->assign('nickname',$user['nickname']);
      $this->display();
    }

    public function http_get_data($url) {  
      
      $ch = curl_init ();  
      curl_setopt ( $ch, CURLOPT_CUSTOMREQUEST, 'GET' );  
      curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, false );  
      curl_setopt ( $ch, CURLOPT_URL, $url );  
      ob_start ();  
      curl_exec ( $ch );  
      $return_content = ob_get_contents ();  
      ob_end_clean ();  
        
      $return_code = curl_getinfo ( $ch, CURLINFO_HTTP_CODE );  
      return $return_content;  
    }  

    public function getImage(){
      $url = $_GET['url'];
      // $url = str_replace( 'http://wx.qlogo.cn/', 'http://wx.izhida.cn/', $url);
      $data  = $this->http_get_data($url);
      echo $data;
      return;
    }

    
    public function cookie()
    {
        SignedCookie::set_cookie($this->cookie_uid_key, 'oMDOGs4ynBPiSItzoGz5FAZdlpuA', C('cookie_sign'), 86400 * 60);
    }
}